//
//  Tui.h
//  TuiFramework
//
//  Copyright (c) 2011 Catalystwo Ltd. All rights reserved.
//

#ifndef TUI_H
#define TUI_H

#if TARGET_OS_IPHONE


#import "MNTextScrollView.h"
#import "MNTextView.h"
#import "MNFramesetter.h"
#import "IndexedPosition.h"
#import "MNPopoverController.h"
#import "MNDraggingProtocol.h"
#import "MNDraggingSourceView.h"
#import "MNDragGestureRecognizer.h"
#import "MNDraggingObject.h"
#import "DraggingTooltipView.h"

#import "MNSplitViewController.h"
#import "TuiColorPicker.h"
#import "MNBlockAlertView.h"
#import "MNBlockActionSheet.h"
#import "MNClickGestureRecognizer.h"
#import "KeychainCenter.h"
#import "KeychainItemWrapper.h"
#import "FontPickerViewController.h"
#import "MNAttributedTextLabel.h"
#import "UIView+Animation.h"
#import "UIImage+Rotation.h"
#import "TuiShadowView.h"
#import "MNCoreTextDefinitions.h"
#import "MNCTFontUtils.h"
#import "MNAttributedTextLabel.h"
#import "MNMenuView.h"
#import "NSString+MNPath.h"
#import "Reachability.h"

#import "UIWindow+MNExtension.h"
#import "NSString+LionEmoji.h"
#import "MNAttachmentCell.h"
#import "DrawUtils.h"
#import "MNCheckboxAttachmentCell.h"


#else


#import "MNFramesetter.h"

#import "KeychainCenter.h"
#import "KeychainItemWrapper.h"
#import "MNCoreTextDefinitions.h"
#import "MNCTFontUtils.h"
#import "MNMenuViewMac.h"
#import "NSString+MNPath.h"
#import "Reachability.h"
#import "NSString+LionEmoji.h"
#import "NSDocument+TuiExtension.h"
#import "DrawUtils.h"
#import "MNAttachmentCell.h"
#import "MNCheckboxAttachmentCell.h"
#endif

#endif


extern void MNRunDraw(CTRunRef run,
							 CGContextRef ctx,
							 CFRange range,
							 BOOL printingResolution,
							 BOOL ignoreScaling);


/*
 *  Definitions.h
 *  MNCTTextView
 *
 */


#ifndef MNLOG
#ifdef DEBUG
//#define MNLOG	NSLog
#define MNLOG( fmt, ... )	//

#else
#define MNLOG( fmt, ... )	//
#endif
#endif


#ifndef MAXRANGE
#define MAXRANGE(r) \
r.location+r.length
#endif


#ifndef RANGECONTAINSLOCATION
#define RANGECONTAINSLOCATION(r1, r2) \
((r1.location <= r2) && r2<(r1.location+r1.length) )
#endif



#ifndef RGBA

#if TARGET_OS_IPHONE

#define RGBA(r,g,b,a) [UIColor colorWithRed: r/255.0f green: g/255.0f \
blue: b/255.0f alpha: a]

#else

#define RGBA(r,g,b,a) [NSColor colorWithCalibratedRed: r/255.0f green: g/255.0f \
blue: b/255.0f alpha: a]


#endif

#endif

#ifndef SHOW_ERROR
#define SHOW_ERROR(n1, n2) 		{ UIAlertView *alert = [[[UIAlertView alloc] initWithTitle:NSLocalizedString((n1==nil?@"":n1),@"")\
message:NSLocalizedString((n2==nil?@"":n2),@"")\
delegate:nil cancelButtonTitle: NSLocalizedString(@"OK",@"") otherButtonTitles:nil] autorelease];\
[alert show];}

#if TARGET_OS_IPHONE
#define SHOW_ERROR_ARC(n1,n2) 		{UIAlertView *alert = [[UIAlertView alloc] initWithTitle:NSLocalizedString(n1,@"")\
message:NSLocalizedString(n2,@"")\
delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil];\
[alert show];}
#else
#define SHOW_ERROR_ARC(n1,n2) [[NSAlert alertWithMessageText:NSLocalizedString(n1,@"")  defaultButton: NSLocalizedString(@"OK",@"") alternateButton:nil otherButton:nil informativeTextWithFormat:NSLocalizedString(n2,@"")] runModal];
#endif

#endif



#ifndef IS_RUNNING_ON_IPAD
#define IS_RUNNING_ON_IPAD ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPad)
#endif

#ifndef SCREEN_SIZE
#define SCREEN_SIZE  [[UIScreen mainScreen] bounds].size
#endif

#ifndef SCREEN_SCALE
#define SCREEN_SCALE	[[UIScreen mainScreen] scale]
#endif


#if TARGET_OS_IPHONE
#if TARGET_IPHONE_SIMULATOR
#define ICLOUD_ENABLED NO
#else
#define ICLOUD_ENABLED NO
#endif
#else
#define ICLOUD_ENABLED NO
#endif





#define DOCUMENT_FOLDER [NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES) objectAtIndex:0]

#define FF_FONTS_FOLDER [DOCUMENT_FOLDER stringByAppendingPathComponent:@"Fonts"]


//#define ATTACHMENT_FOLDER [DATABASE_FOLDER stringByAppendingPathComponent:@"Attachments"]
#define PASTEBOARD_FOLDER [DOCUMENT_FOLDER stringByAppendingPathComponent:@"Clipboard"]
#define SKP_PASTEBOARD_FOLDER [DOCUMENT_FOLDER stringByAppendingPathComponent:@"Sketch Pad Clipboard"]

#define DIFPOINTS(n1,n2) CGPointMake( n2.x - n1.x, n2.y - n1.y)
#define ADDPOINTS(n1,n2) CGPointMake( n2.x + n1.x, n2.y + n1.y)
#define CGPOINTINTEGRATE(n) CGPointMake( roundf(n.x), roundf(n.y))
#define DISTANCE(n) sqrtf( n.x*n.x + n.y*n.y )

// Resource support

extern NSString* TuiLocalizable(NSString* key);
extern NSString* TuiEmojiLocalizable(NSString* key);



/// iPhone/Mac Support

// iOS
#if TARGET_OS_IPHONE
#define CURRENT_CONTEXT UIGraphicsGetCurrentContext()
#else

// OSX
#define CURRENT_CONTEXT (CGContextRef)[[NSGraphicsContext currentContext] graphicsPort]

#import "MNCGGeometryForMac.h"
//#import "MNDocument.h"
#import "NSColor+CGColor.h"

#endif

